<?php

// Get the invoice ID from the URL
$invoice_id = isset($_GET['invoiceID']) ? $_GET['invoiceID'] : null;

// Check if invoice ID is provided
if (!$invoice_id) {
    echo "Invoice ID is required.";
    exit;
}

// API URL
$api_url = "https://hapitest.xyz/hapi%20bilzs%20sts/hapi%20commers/api/invoicepdfdata-api.php";

// Initialize cURL
$ch = curl_init();

// Set cURL options
curl_setopt($ch, CURLOPT_URL, $api_url . "?invoiceID=" . urlencode($invoice_id));
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HTTPGET, true);

// Execute the request
$response = curl_exec($ch);

// Check for cURL errors
if (curl_errno($ch)) {
    echo "Failed to fetch data from API: " . curl_error($ch);
    curl_close($ch);
    exit;
}

// Close cURL
curl_close($ch);

// Decode the JSON response
$data = json_decode($response, true);

// Check if JSON decoding was successful
if (json_last_error() !== JSON_ERROR_NONE) {
    echo "Failed to decode API response: " . json_last_error_msg();
    exit;
}
// Extract profile and invoice data
$profile = $data['profile'];
$invoice_data = $data['invoice_data'];

$output = '

<!DOCTYPE html>

<html lang="en">

<head>

    <meta charset="UTF-8">

    <meta http-equiv="X-UA-Compatible" content="IE=edge">

    <meta name="viewport" content="width=device-width, initial-scale=1">

    <title>Invoice</title>

    <link rel="stylesheet" type="text/css" href="pdfstyle/main-style.css">

    <style>

  

        body { background-color: #f9f9f9; }

        .terms .headtxt {

            font-size: 15px;

            font-weight: 600;

        }



        .terms p {

            text-align: justify;

        }



        .table1 tr td {

            padding: 5px;

        }



        .table1 {

            width: 100%;

            margin: 0 auto; 

        }



        .table1 td {

            text-align: right;

        }



        .img-container {

            border: 1px solid lightgray;

            width: 100px;

            height: 100px;

            display: flex;

            justify-content: center;

            align-items: center;

            position: relative;

        }



        .img-container img {

            max-width: 100%;

            max-height: 100%;

            object-fit: cover; 

        }

    </style>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/html2pdf.js/0.9.2/html2pdf.bundle.min.js"></script>

    <script>

    document.addEventListener("DOMContentLoaded", function() {

        document.getElementById("bill-download").addEventListener("click", function() {

            var element = document.getElementById("download-section");

            var opt = {

                margin: [0.5, 0.3, 0.5, 0.3],

                filename: "invoice.pdf",

                image: { type: "jpeg", quality: 0.98 },

                html2canvas: { scale: 2 },

                jsPDF: { unit: "in", format: "letter", orientation: "portrait" }

            };

            html2pdf().from(element).set(opt).save();

        });

    });

    </script>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <script>

        $(document).ready(function () {

            var $img = $(".img-container img");

            var $container = $(".img-container");



            function handleImageLoad() {

                if ($img[0].complete && $img[0].naturalWidth === 0) {

                    $container.removeClass("no-border");

                } else {

                    $container.addClass("no-border");

                }

            }



            $img.on("error", function () {

                $container.removeClass("no-border"); 

            });



            $img.on("load", function () {

                $container.addClass("no-border");

            });



            handleImageLoad();

        });

    </script>

</head>

<body>

    <main class="container invoice-wrapper">

        <div id="download-section">

            <div class="invoice-top">

                <div class="row align-items-center">

                    <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 text-center text-sm-start mb-3 mb-sm-1">

                        <a href="index.html"><img src="'.htmlspecialchars($profile['logopath']).'" title="invoice" alt="invoice" width="130px"></a>

                    </div>

                    <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 text-center text-sm-end mb-3 mb-sm-1">

                        <h4 class="text-30 mb-0 mt-0">Invoice</h4>

                    </div>

                </div>

                <hr>

                <div class="row">

                    <div class="col-sm-6"><strong>Invoice Date:</strong> '.htmlspecialchars($profile['invoicedate']).'</div>

                    <div class="col-sm-6 text-sm-end">

                        <strong>Invoice No :</strong> '.htmlspecialchars($profile['invoiceno']).'

                    </div>

                </div>

                <div class="row mt-2">

                    <div class="col-sm-12 text-end">

                        <!-- Conditional Order No. -->

                        '.($profile['orderid'] ? '<strong>Order No :</strong> '.$profile['orderid'].'<br />' : '').'

                    </div>

                </div>

                <hr>

            </div>

            <hr>

          <div class="invoice-details border-top mt-20 pt-20">

            <div class="row">

                <div class="col-sm-6 text-sm-end order-sm-1">

                    <strong class="text-18 mb-3 d-inline-block">Pay To:</strong>

                    <address class="mb-4">

                        <b style="">'. htmlspecialchars($profile['storename']) . ',</b><br/>

                        '. htmlspecialchars($profile['street1']) .' , <br/>

                        ' . htmlspecialchars($profile['street2']) .',<br/>

                        '. htmlspecialchars($profile['city']) .', <br/>

                        '. htmlspecialchars($profile['pincode']) .' <br/>

                        ' . htmlspecialchars($profile['phonenumber']) .'<br/>

                        '. htmlspecialchars($profile['email']) . '

                    </address>



                </div>

                <div class="col-sm-6 order-sm-0">

                    <strong class="text-18 mb-3 d-inline-block">Invoiced To:</strong>

                    <address class="mb-4">

                        '. htmlspecialchars($profile['displayname']) .'<br>

                        '. htmlspecialchars($profile['address']) .',<br>
                        
                        '. htmlspecialchars($profile['address2']) .',<br>

                        '. htmlspecialchars($profile['customer_city']) .', <br/>

                        Pin:'. htmlspecialchars($profile['customer_pincode']) .'<br>

                        '. htmlspecialchars($profile['phoneno']) .'<br>

                        '.htmlspecialchars($profile['customer_email']) .'

                    </address>

                </div>

            </div>

         </div>

            <div class="card mb-3">

                <div class="card-body p-0">

                    <div class="table-responsive">

                        <table class="table mb-0">

                            <thead class="card-header">

                                <tr>

                                    <td class="col-2"><strong>S. No</strong></td>

                                    <td class="col-9"><strong>Product Name</strong></td>

                                    <td class="col-4"><strong>Qty</strong></td>

                                    <td class="col-3 text-center"><strong>MRP</strong></td>

                                    <td class="col-3 text-center"><strong>Rate</strong></td>

                                    <td class="col-3 text-end"><strong>Disc</strong></td>

                                    <td class="col-3 text-end"><strong>Tax</strong></td>

                                    <td class="col-3 text-end"><strong>Amount</strong></td>

                                </tr>

                            </thead>

                          <tbody>';

                          $count = 0;
                          $productsPerPage = 25;
                          $totalsavings = htmlspecialchars($profile['totalsavings']);
                          $grandtotal = htmlspecialchars($profile['grandtotal']);
                          $notes = htmlspecialchars($profile['notes']);
                          $terms = htmlspecialchars($profile['terms']);
                          $qrcode = $profile['qrcode'] ? $profile['qrcode'] : ''; // Check if qrcode is available
                          $accountno = htmlspecialchars($profile['account']);
                          $ifsc = htmlspecialchars($profile['ifsc']);
                          $bank = htmlspecialchars($profile['bankname']);
                          $upiid = htmlspecialchars($profile['upiid']);
                          foreach ($invoice_data as $item) {
                              $count++;
                              $output .= ' 
                                  <tr>
                                      <td class="col-3">' . $count . '</td> 
                                      <td class="col-3">' . htmlspecialchars($item['Product_name']) . '</td>  
                                      <td class="col-4">' . htmlspecialchars($item['Qty']) . '</td>  
                                      <td class="col-2 text-center">' . htmlspecialchars($item['MRP']) . '</td>  
                                      <td class="col-1 text-center">' . htmlspecialchars($item['Selling_price']) . '</td>  
                                      <td class="col-2 text-end">' . htmlspecialchars($item['Discount_percentage']) . '%</td>  
                                      <td class="col-2 text-end">' . htmlspecialchars($item['Tax']) . '</td>  
                                      <td class="col-2 text-end">' . htmlspecialchars($item['Product_total']) . '</td>  
                                  </tr>';   
                          
                              // Check if it's time for a page break
                              if ($count % $productsPerPage == 0) {
                                  $output .= '</tbody></table><div style="page-break-before:always;"></div><table class="table mb-0"><thead class="card-header"><tr><td class="col-3"><strong>Number</strong></td><td class="col-3"><strong>Product Name</strong></td><td class="col-4"><strong>Qty</strong></td><td class="col-2 text-center"><strong>MRP</strong></td><td class="col-1 text-center"><strong>Rate</strong></td><td class="col-2 text-end"><strong>Disc</strong></td><td class="col-2 text-end"><strong>Tax</strong></td><td class="col-2 text-end"><strong>Amount</strong></td></tr></thead><tbody>';
                              }
                          }

                          $tax_data = $data['taxvalue']; // Assuming $data['taxvalue'] holds the total tax information

                          // Tax calculations
                          $taxs = $item['Tax_percentage'] / 2; 
                          $taxvalue = $tax_data / 2;  
                          
                          if ($taxs != "") {
                              $output .= ' 
                                  <tr>
                                      <td colspan="7" class="text-end"><strong>CGST@ '. $taxs.'% </strong></td>
                                      <td class="text-end">'.number_format($taxvalue,2).'</td>       
                                  </tr>
                                  <tr>
                                      <td colspan="7" class="text-end"><strong>SGST@ '. $taxs.'% </strong></td>
                                      <td class="text-end">'.number_format($taxvalue,2).'</td>       
                                  </tr>
                              '; 
                          }
                          
                          $output .= '
                          <tr>
                              <td colspan="7" class="text-end"><strong>Total Savings: </strong></td>
                              <td class="text-end">₹'.$totalsavings.'.00</td>       
                          </tr>
                          <tr>
                              <td colspan="7" class="text-end"><strong>Total:</strong></td>
                              <td class="text-end"><strong>₹'.$grandtotal.'.00</strong></td>       
                          </tr>
                          </tbody>
                          </table>
                          </div>
                          </div>
                          </div>
                          </tbody>
                          </table>
                          <div class="invoice-footer text-left mt-20">
                           <div class="headtxt">Note: </div>
                              <p>'.$notes.'</p>
                          </div>
                          <br>
                          <div class="terms">
                              <div class="row">
                                  <div class="col-md-7 text-left">
                                      <div class="headtxt">Terms & Conditions: </div>
                                      <p>'.$terms.'</p>
                                      <br>
                                  </div>
                                  <div class="col-md-1"></div>
                                  <div class="col-md-4 text-right" style="display: flex; flex-direction: column; align-items: flex-end;">
                                      <div class="img-container">
                                          <img src="'.$qrcode.'" alt=""/>
                                      </div>
                                      <br>
                                      <table class="table1 text-right">
                                          <tr>
                                              <td>Account No: </td>
                                              <td>'.$accountno.' </td>
                                          </tr>
                                          <tr>
                                              <td>IFSC Code: </td>
                                              <td>'.$ifsc.'</td>
                                          </tr>
                                          <tr>
                                              <td>Bank Name: </td>
                                              <td>'.$bank.'</td>
                                          </tr>
                                          <tr>
                                              <td>UPI ID: </td>
                                              <td>'.$upiid.'</td>
                                          </tr>
                                      </table>
                                  </div>
                              </div>
                          </div>
                          </div>
                      </div>
                      
                      <div class="text-center mt-5 mb-4 regular-button">
                          <div class="d-print-none d-flex justify-content-center flex-wrap gap-10"> 
                              <button id="bill-download" class="btn-primary-outline">Download</button> 
                              <a href="javascript:window.print()" class="btn-primary-fill">Print Invoice</a> 
                          </div>
                      </div>
                      </body>
                      </html>';

// Output the final HTML

echo $output;

?>

